unit frmUserDetails;

interface

uses
  System.Drawing, System.Collections, System.ComponentModel,
  System.Windows.Forms, System.Data, clsUserDetails;

type
  TfrmUserDetails = class(System.Windows.Forms.Form)
  {$REGION 'Designer Managed Code'}
  strict private
    /// <summary>
    /// Required designer variable.
    /// </summary>
    Components: System.ComponentModel.Container;
    txtName: System.Windows.Forms.TextBox;
    Label1: System.Windows.Forms.Label;
    Label2: System.Windows.Forms.Label;
    txtDepartment: System.Windows.Forms.TextBox;
    Label3: System.Windows.Forms.Label;
    btnOK: System.Windows.Forms.Button;
    btnCancel: System.Windows.Forms.Button;
    txtHireDate: System.Windows.Forms.TextBox;
    /// <summary>
    /// Required method for Designer support - do not modify
    /// the contents of this method with the code editor.
    /// </summary>
    procedure InitializeComponent;
    procedure btnOK_Click(sender: System.Object; e: System.EventArgs);
  {$ENDREGION}
  strict protected
    /// <summary>
    /// Clean up any resources being used.
    /// </summary>
    procedure Dispose(Disposing: Boolean); override;
  private
    fUser : TUser;
    procedure SetUser(Value : TUser);
    procedure BindUserToForm;
    procedure HireDateFormat(sender : TObject ; e : ConvertEventArgs);
    procedure HireDateParse(sender : TObject ; e : ConvertEventargs);
  public
    constructor Create;
    property User : TUser read fUser write SetUser;
  end;

  [assembly: RuntimeRequiredAttribute(TypeOf(TfrmUserDetails))]

implementation

{$REGION 'Windows Form Designer generated code'}
/// <summary>
/// Required method for Designer support -- do not modify
/// the contents of this method with the code editor.
/// </summary>
procedure TfrmUserDetails.InitializeComponent;
begin
  Self.txtName := System.Windows.Forms.TextBox.Create;
  Self.Label1 := System.Windows.Forms.Label.Create;
  Self.Label2 := System.Windows.Forms.Label.Create;
  Self.txtDepartment := System.Windows.Forms.TextBox.Create;
  Self.Label3 := System.Windows.Forms.Label.Create;
  Self.btnOK := System.Windows.Forms.Button.Create;
  Self.btnCancel := System.Windows.Forms.Button.Create;
  Self.txtHireDate := System.Windows.Forms.TextBox.Create;
  Self.SuspendLayout;
  // 
  // txtName
  // 
  Self.txtName.Anchor := (System.Windows.Forms.AnchorStyles(((System.Windows.Forms.AnchorStyles.Top 
    or System.Windows.Forms.AnchorStyles.Left) or System.Windows.Forms.AnchorStyles.Right)));
  Self.txtName.BorderStyle := System.Windows.Forms.BorderStyle.FixedSingle;
  Self.txtName.Location := System.Drawing.Point.Create(16, 32);
  Self.txtName.Name := 'txtName';
  Self.txtName.Size := System.Drawing.Size.Create(208, 20);
  Self.txtName.TabIndex := 0;
  Self.txtName.Text := '';
  // 
  // Label1
  // 
  Self.Label1.Location := System.Drawing.Point.Create(16, 16);
  Self.Label1.Name := 'Label1';
  Self.Label1.Size := System.Drawing.Size.Create(100, 16);
  Self.Label1.TabIndex := 1;
  Self.Label1.Text := 'Name';
  // 
  // Label2
  // 
  Self.Label2.Location := System.Drawing.Point.Create(16, 56);
  Self.Label2.Name := 'Label2';
  Self.Label2.TabIndex := 2;
  Self.Label2.Text := 'Department';
  // 
  // txtDepartment
  // 
  Self.txtDepartment.Anchor := (System.Windows.Forms.AnchorStyles(((System.Windows.Forms.AnchorStyles.Top 
    or System.Windows.Forms.AnchorStyles.Left) or System.Windows.Forms.AnchorStyles.Right)));
  Self.txtDepartment.BorderStyle := System.Windows.Forms.BorderStyle.FixedSingle;
  Self.txtDepartment.Location := System.Drawing.Point.Create(16, 72);
  Self.txtDepartment.Name := 'txtDepartment';
  Self.txtDepartment.Size := System.Drawing.Size.Create(208, 20);
  Self.txtDepartment.TabIndex := 3;
  Self.txtDepartment.Text := '';
  // 
  // Label3
  // 
  Self.Label3.Location := System.Drawing.Point.Create(16, 96);
  Self.Label3.Name := 'Label3';
  Self.Label3.Size := System.Drawing.Size.Create(100, 16);
  Self.Label3.TabIndex := 5;
  Self.Label3.Text := 'Hire Date';
  // 
  // btnOK
  // 
  Self.btnOK.Anchor := (System.Windows.Forms.AnchorStyles((System.Windows.Forms.AnchorStyles.Bottom 
    or System.Windows.Forms.AnchorStyles.Right)));
  Self.btnOK.Location := System.Drawing.Point.Create(72, 144);
  Self.btnOK.Name := 'btnOK';
  Self.btnOK.TabIndex := 6;
  Self.btnOK.Text := 'OK';
  Include(Self.btnOK.Click, Self.btnOK_Click);
  // 
  // btnCancel
  // 
  Self.btnCancel.Anchor := (System.Windows.Forms.AnchorStyles((System.Windows.Forms.AnchorStyles.Bottom 
    or System.Windows.Forms.AnchorStyles.Right)));
  Self.btnCancel.DialogResult := System.Windows.Forms.DialogResult.Cancel;
  Self.btnCancel.Location := System.Drawing.Point.Create(152, 144);
  Self.btnCancel.Name := 'btnCancel';
  Self.btnCancel.TabIndex := 7;
  Self.btnCancel.Text := 'Cancel';
  // 
  // txtHireDate
  // 
  Self.txtHireDate.Anchor := (System.Windows.Forms.AnchorStyles(((System.Windows.Forms.AnchorStyles.Top 
    or System.Windows.Forms.AnchorStyles.Left) or System.Windows.Forms.AnchorStyles.Right)));
  Self.txtHireDate.BorderStyle := System.Windows.Forms.BorderStyle.FixedSingle;
  Self.txtHireDate.Location := System.Drawing.Point.Create(16, 112);
  Self.txtHireDate.Name := 'txtHireDate';
  Self.txtHireDate.Size := System.Drawing.Size.Create(208, 20);
  Self.txtHireDate.TabIndex := 8;
  Self.txtHireDate.Text := '';
  // 
  // TfrmUserDetails
  // 
  Self.AcceptButton := Self.btnOK;
  Self.AutoScaleBaseSize := System.Drawing.Size.Create(5, 13);
  Self.CancelButton := Self.btnCancel;
  Self.ClientSize := System.Drawing.Size.Create(240, 174);
  Self.Controls.Add(Self.txtHireDate);
  Self.Controls.Add(Self.btnCancel);
  Self.Controls.Add(Self.btnOK);
  Self.Controls.Add(Self.Label3);
  Self.Controls.Add(Self.txtDepartment);
  Self.Controls.Add(Self.Label2);
  Self.Controls.Add(Self.Label1);
  Self.Controls.Add(Self.txtName);
  Self.Name := 'TfrmUserDetails';
  Self.Text := 'User Details';
  Self.ResumeLayout(False);
end;
{$ENDREGION}

procedure TfrmUserDetails.Dispose(Disposing: Boolean);
begin
  if Disposing then
  begin
    if Components <> nil then
      Components.Dispose();
  end;
  inherited Dispose(Disposing);
end;

constructor TfrmUserDetails.Create;
begin
  inherited Create;
  //
  // Required for Windows Form Designer support
  //
  InitializeComponent;
  //
  // TODO: Add any constructor code after InitializeComponent call
  //
end;

procedure TfrmUserDetails.btnOK_Click(sender: System.Object; e: System.EventArgs);
begin

  DialogResult := System.Windows.Forms.DialogResult.OK;
end;

procedure TfrmUserDetails.SetUser(Value: TUser);
begin
  fUser := Value;
  BindUserToForm;
end;

procedure TfrmUserDetails.BindUserToForm;
var
  hdBinding : Binding;
begin
  txtName.DataBindings.Add('Text',fUser,'Name');
  txtDepartment.DataBindings.Add('Text',fUser,'Department');
  hdBinding := Binding.Create('Text',fUser,'HireDate');
  include(hdBinding.Parse,HireDateParse);
  include(hdBinding.Format,HireDateFormat);
  txtHireDate.DataBindings.Add(hdBinding);
end;

procedure TfrmUserDetails.HireDateFormat(sender: TObject;
  e: ConvertEventArgs);
begin
   if(e.DesiredType = typeof(string)) then
   begin
     e.Value := (System.DateTime(TDateTime(e.Value)).ToString('dd/MM/yyyy'));
   end;
end;

procedure TfrmUserDetails.HireDateParse(sender: TObject;
  e: ConvertEventargs);
begin
  if (e.DesiredType = typeof(TDateTime)) then
  begin
    e.Value := TDateTime.Parse(e.Value.ToString);
  end;
end;

end.
